#!/bin/bash

current_path=`pwd`

# $0 代表当前执行脚本的位置（名称） 例如执行 /application/bin/dockerStartup.sh  $0=/application/bin/dockerStartup.sh
# 执行 ./bin/dockerStartup.sh $0=./bin/dockerStartup.sh

# 获取脚本的绝对路径
case "`uname`" in
    Linux)
		bin_abs_path=$(readlink -f $(dirname $0))
		;;
	*)
		bin_abs_path=`cd $(dirname $0); pwd`
		;;
esac
base=${bin_abs_path}/..

get_pid() {
	APP_NAME=$1
	PID=$2
	GREP_NAME="DappName=$APP_NAME"
	if [ ! -z "$PID" ];then
	  JAVA_PID=`ps aux |grep "$GREP_NAME"|grep "$PID"|grep -v grep|awk '{print $2}'`
	else
    JAVA_PID=`ps aux |grep "$GREP_NAME"|grep java|grep -v grep|awk '{print $2}'`
    echo $JAVA_PID;
  fi
}

pidfile=$base/bin/app.pid
if [ ! -f "$pidfile" ];then
	if [ -z "$APP_NAME" ] ; then
      APP_NAME=`cat $base/applicationName.txt`
  fi
  pid=`get_pid "$APP_NAME"`
else
  pid=`cat $pidfile`
    if [ -z "$pid" ] ; then
      if [ -z "$APP_NAME" ] ; then
        APP_NAME=`cat $base/applicationName.txt`
      fi
    	pid=`get_pid "$APP_NAME"`
    fi
fi
echo $pid
KILL_APP_NAME=`cat $base/applicationName.txt`

if [ -z "$pid" ];then
  echo "$KILL_APP_NAME is not running! exit."
  exit
fi


echo -e "`hostname`: stopping $KILL_APP_NAME $pid ... "
kill $pid

LOOPS=0
while (true);
do
	gpid=`get_pid "$APP_NAME" $pid`
    if [ "$gpid" == "" ] ; then
    	echo "Oook! cost:$LOOPS"
    	`rm $pidfile`
    	break;
    fi
    let LOOPS=LOOPS+1
    sleep 1
done