#!/bin/bash

current_path=`pwd`

# $0 代表当前执行脚本的位置（名称） 例如执行 /application/bin/dockerStartup.sh  $0=/application/bin/dockerStartup.sh
# 执行 ./bin/dockerStartup.sh $0=./bin/dockerStartup.sh

# 获取脚本的绝对路径
case "`uname`" in
    Linux)
		bin_abs_path=$(readlink -f $(dirname $0))
		;;
	*)
		bin_abs_path=`cd $(dirname $0); pwd`
		;;
esac
base=${bin_abs_path}/..

export LANG=en_US.UTF-8
export BASE=$base

## 设置java的路径，可以按实际的情况来写
if [ -z "$JAVA" ] ; then
  JAVA=$(which java)
fi

ALIBABA_JAVA="/usr/alibaba/java/bin/java"
TAOBAO_JAVA="/opt/taobao/java/bin/java"
if [ -z "$JAVA" ]; then
  if [ -f $ALIBABA_JAVA ] ; then
  	JAVA=$ALIBABA_JAVA
  elif [ -f $TAOBAO_JAVA ] ; then
  	JAVA=$TAOBAO_JAVA
  else
  	echo "Cannot find a Java JDK. Please set either set JAVA or put java (>=1.5) in your PATH." 2>&2
    exit 1
  fi
fi

# 循环处理所有传递给脚本的参数
for arg in "$@"
do
    case $arg in
        -Xms*) XMS=$arg ;;
        -Xmx*) XMX=$arg ;;
        *) echo "未知参数: $arg" ;;
    esac
done

echo "Xms参数为: $XMS"
echo "Xmx参数为: $XMX"


#环境变量设置
if [ -z "$JAVA_MEM_OPTS" ] ; then
  JAVA_MEM_OPTS="$XMS $XMX "
fi
if [ -z "$JAVA_GC_OPTS" ] ; then
  JAVA_GC_OPTS="-XX:+UseG1GC -XX:MaxGCPauseMillis=250 -XX:+UseGCOverheadLimit -XX:+ExplicitGCInvokesConcurrent "
fi
if [ -z "$JAVA_OTHER_OPTS" ] ; then
  JAVA_OTHER_OPTS="-Djava.awt.headless=true -Djava.net.preferIPv4Stack=true -Dfile.encoding=UTF-8 "
fi
if [ -z "$APP_NAME" ] ; then
  APP_NAME=`cat $base/applicationName.txt`
fi
JAVA="java -server"
SERVER_NAME="-DappName=$APP_NAME"

JAR_NAME=`ls | grep ".jar"`

echo "cd to $bin_abs_path for workaround relative path"
cd $base
#后台运行，并且输出控制台日志到/dev/null （无底洞）
nohup $JAVA $SERVER_NAME $JAVA_MEM_OPTS $JAVA_GC_OPTS $JAVA_OTHER_OPTS $JAVA_DEBUG_OPT -jar $JAR_NAME  > /dev/null  2>&1 &
echo $! > $base/bin/app.pid