#!/bin/bash

current_path=`pwd`

# $0 代表当前执行脚本的位置（名称） 例如执行 /application/bin/dockerStartup.sh  $0=/application/bin/dockerStartup.sh
# 执行 ./bin/dockerStartup.sh $0=./bin/dockerStartup.sh

# 获取脚本的绝对路径
case "`uname`" in
    Linux)
		bin_abs_path=$(readlink -f $(dirname $0))
		;;
	*)
		bin_abs_path=`cd $(dirname $0); pwd`
		;;
esac
base=${bin_abs_path}/..

export LANG=en_US.UTF-8
export BASE=$base

#环境变量设置
if [ -z "$JAVA_MEM_OPTS" ] ; then
  JAVA_MEM_OPTS="-Xms512m -Xmx512m "
fi
if [ -z "$JAVA_GC_OPTS" ] ; then
  JAVA_GC_OPTS="-XX:+UseG1GC -XX:MaxGCPauseMillis=250 -XX:+UseGCOverheadLimit -XX:+ExplicitGCInvokesConcurrent "
fi
if [ -z "$JAVA_OTHER_OPTS" ] ; then
  JAVA_OTHER_OPTS="-Djava.awt.headless=true -Djava.net.preferIPv4Stack=true -Dfile.encoding=UTF-8 "
fi
if [ -z "$APP_NAME" ] ; then
  APP_NAME="default-app"
fi
JAVA="java -server"
SERVER_NAME="-DappName=$APP_NAME"


echo "cd to $bin_abs_path for workaround relative path"
cd $base
#echo CLASSPATH :$CLASSPATH
exec $JAVA $SERVER_NAME $JAVA_MEM_OPTS $JAVA_GC_OPTS $JAVA_OTHER_OPTS $JAVA_DEBUG_OPT org.springframework.boot.loader.JarLauncher